define([
    'backbone',
    'models/singleton-collection',
], function(Backbone, Collection) {
    'use strict';


    var Facility = Backbone.Model.extend({
        idAttribute: 'facilityCode',
        defaults: {
            'name': '',
            'type': '',
            'facilityCode': '',
            'state': '',
            'city': '',
            'address': '',
            'parentSiteCode': '',
            'supportsVAR': false,
        },
    });


    return Collection.extend({
        resourceName: 'facilities',
        defaultsFetchOptions: {
            cache: false,
        },
        model: Facility,
        parse: function(response) {
            return response.facility;
        },
    });
});
